/*----------------------------------------------------------------------------
 * Name:    service.c
 * Purpose:
 * Note(s):
 *----------------------------------------------------------------------------
 * This file is part of the uVision/ARM development tools.
 * This software may only be used under the terms of a valid, current,
 * end user licence from KEIL for a compatible version of KEIL software
 * development tools. Nothing else gives you the right to use this software.
 *
 * This software is supplied "AS IS" without warranties of any kind.
 *
 * Copyright (c) 2012 Keil - An ARM Company. All rights reserved.
 *----------------------------------------------------------------------------*/
#include		<string.h>
#include		"timer.h"
#include		"ble.h"
#include		"hci.h"
#include		"service.h"
#include		"bleprocess.h"

/*------------------------------------------------------------------------------
* Function Name : ServiceParameterConfigure
* Description   : Service Parameter Configure
* Input         :
*				- item : Configured items
* Output        : None
* Return        : None
* 				- TRUE : The configured item is successful
* 				- FALSE: The configured item is empty(indicating the end of the configuration)
------------------------------------------------------------------------------*/
void *ServiceParameterConfigure(u8 *item)
{
	void *pret;

	switch(*item)
	{
		case 0:
			if((pret=BPS_MeasFeatureConfigure()) != NULL) *item=1;	//to next modify
			break;
		case 1:
			if((pret=WSS_MeasFeatureConfigure()) != NULL) *item=2;	//to next modify
			break;
		default:
			*item = 0xFF;
			pret = NULL;
			break;
	}
	return(pret);
}
/*------------------------------------------------------------------------------
* Function Name : GetServiceProperties
* Description   : Get service properties
* Input         :
*				- opcode : service UUID
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
void *GetServiceProperties(u16 opcode)
{
	return(BCI_SendBCIReadPackage(opcode,BCI_ServiceProperties));
}
/*------------------------------------------------------------------------------
* Function Name : ServicePropertiesProcess
* Description   : service properties status process
* Input         : None
* Output        : None
* Return        :
* 				- bool flag
*					- TRUE : service opcode is matching
*					- FALSE : service opcode is not matching
------------------------------------------------------------------------------*/
bool ServicePropertiesProcess(tPROPERTIES *sp,tBCI_PACKAGE *pld)
{
	bool ret = FALSE;
	vu8	stscode;
	vu16 	opcode;

	stscode = pld->flag & EVTS_CODE_MASK;
	opcode = (pld->param[1] << 8) + pld->param[0];
	switch(pld->opcode)
	{
		case Battery:
		case BatteryLevel:
			if((pld->length == 3) ||
				((pld->length == 5) && (opcode == BatteryLevel)))
			{
				if((stscode == EVTS_SUCCESS) || (stscode == EVTS_NOT_ENABLE))
				{
					sp->b.battery = (stscode == EVTS_SUCCESS) ? 1 : 0;
					ret = TRUE;
				}
			}
			break;
		case BloodPressure:
		case BloodMeasurement:
			if((pld->length == 3) ||
				((pld->length == 5) && ( opcode == BloodMeasurement)))
			{
				if((stscode == EVTS_SUCCESS) || (stscode == EVTS_NOT_ENABLE))
				{
					sp->b.bps_measurement = (stscode == EVTS_SUCCESS) ? 1 : 0;
					ret = TRUE;
				}
			}
			break;
		case WeightScale:
		case WeightMeasurement:
			if((pld->length == 3) ||
				((pld->length == 5) && ( opcode == WeightMeasurement)))
			{
				if((stscode == EVTS_SUCCESS) || (stscode == EVTS_NOT_ENABLE))
				{
					sp->b.wss_measurement = (stscode == EVTS_SUCCESS) ? 1 : 0;
					ret = TRUE;
				}
			}
			break;
		case UnknowService:
		case NotifyFFF1:
			if((pld->length == 3) ||
				((pld->length == 5) && (opcode == NotifyFFF1)))
			{
				if((stscode == EVTS_SUCCESS) || (stscode == EVTS_NOT_ENABLE))
				{
					sp->b.uwsFFF1 = (stscode == EVTS_SUCCESS) ? 1 : 0;
					ret = TRUE;
				}
			}
			break;
	}
	return(ret);
}
/*------------------------------------------------------------------------------
* Function Name : BPS_SendMeasurementData
* Description   : Generate Blood Pressure Measurement data package
* Input         :
*				- meas : Blood Pressure Measurement data
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
void *BPS_SendMeasurementData(tBPS_MEAS *meas)
{
	return(BCI_SendBCIPackage(BloodMeasurement,BCI_ServiceProperties,sizeof(tBPS_MEAS),(u8 *)meas));
}
/*------------------------------------------------------------------------------
* Function Name : BPS_MeasFeatureConfigure
* Description   : Generate Blood Pressure feature package
* Input         : None
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
uc16	BPS_MeasFeature = \
						BPS_F_CUFF_FIT_DETECT_SUPPORTED + \
						BPS_F_PULSE_RATE_RANGE_DETECT_SUPPORTED + \
						BPS_F_MEAS_POS_DETECT_SUPPORTED;

void *BPS_MeasFeatureConfigure(void)
{
	return(BCI_SendBCIPackage(BloodFeature,BCI_ServiceMessage,sizeof(u16),(u8 *)&BPS_MeasFeature));
}
/*------------------------------------------------------------------------------
* Function Name : WSS_SendMeasurementData
* Description   : Generate Weight Scale Measurement data package
* Input         : None
*				- meas : Weight Scale Measurement data
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
void *WSS_SendMeasurementData(tWSS_MEAS *meas)
{
	return(BCI_SendBCIPackage(WeightMeasurement,BCI_ServiceProperties,sizeof(tWSS_MEAS),(u8 *)meas));
}
/*------------------------------------------------------------------------------
* Function Name : WSS_MeasFeatureConfigure
* Description   : Generate Weight Scale feature package
* Input         : None
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
uc32	WSS_MeasFeature = \
						WSS_F_TIME_STAMP_SUPPORTED + \
						WSS_F_BMI_SUPPORTED + \
						WSS_F_WEIGHT_MEAS_RESOLUTION_005KG_01LB + \
						WSS_F_HEIGHT_MEAS_RESOLUTION_0005M_05I;

void *WSS_MeasFeatureConfigure(void)
{
	return(BCI_SendBCIPackage(WeightFeature,BCI_ServiceMessage,sizeof(u32),(u8 *)&WSS_MeasFeature));
}
/*------------------------------------------------------------------------------
* Function Name : UWS_SendNotifyFFF1Data
* Description   : Generate UUID:FFF1 notify package
* Input         : None
*				- len : data length
*				- pbuf: data buffer
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
void *UWS_SendNotifyFFF1Data(u8 len,u8 *pbuf)
{
	return(BCI_SendBCIPackage(NotifyFFF1,BCI_ServiceProperties,len,pbuf));
}
/*------------------------------------------------------------------------------
* Function Name : BAS_BatteryLevel
* Description   : Generate UUID:2A19 battery level
* Input         : None
*				- level : battery level
* Output        : None
* Return        : None
------------------------------------------------------------------------------*/
void *BAS_BatteryLevel(u8 level)
{
	return(BCI_SendBCIPackage(BatteryLevel,BCI_ServiceProperties,1,&level));
}

